// PLUGIN CONTROL
// requis pour le plugin experview

GIWIK.init.js(['css','msg'], 'control');


// Retourne l'id DOM du message d'un bit donné (bit unifié)
GIWIK.statusBitsInfo.msgDomId = function (bit_unified)
{
	return "detailedstatus_bit"+bit_unified;
};

// Initialisation de l'objet voué à contenir les groupes contenant eux mêmes les bits de statuts
GIWIK.statusBitsInfo.groups = {raw:{}, names:{},ordered:{}};

// Définit un groupe de messages de statuts (ex. _params : {name:'inputs',  title:"Inputs",  module:0, position:0, open:true})
GIWIK.statusBitsInfo.setGroup = function (_params)
{
	// "name" obligatoire
	if (!_params || typeof _params.name !== 'string' ) {return;}

	// Définition des valeurs par défaut
	if (typeof _params.title    !== 'string' ) {_params.title    = null;}  // aucun titre par défaut
	if (typeof _params.module   !== 'number' ) {_params.module   = -1;  }  // ne s'affiche pas par défaut
	if (typeof _params.position !== 'number' ) {_params.position = -1;  }  // aucune position forcée, la position suit l'ordre de déclaration
	if (typeof _params.openable !== 'boolean') {_params.openable = true;}  // indique si le groupe est ouvrable
	if (typeof _params.open     !== 'boolean' || !_params.openable) {_params.open = _params.openable;}  // si le groupe est ouvrable, son état ouvert/fermé par défaut
	if (typeof _params.visible  !== 'boolean') {_params.visible  = true;}  // indique si le groupe est visible
	if (typeof _params.visible_when_empty !== 'boolean') {_params.visible_when_empty  = true;}  // indique si le groupe est visible quand il est vide (aucune message affiché)

	// Ajout de la propriété "bits" destinée à contenir les bits de statuts définis par GIWIK.statusBitsInfo.set dans GIWIK._status_bits_info
	_params.bits = [];

	// Ajout de l'ID dom du groupe sur la base du paramètre "name" (préfixe + remplacement des caractères spéciaux)
	_params.dom_id = 'ds_group_'+GIWIK.domId(_params.name);

	// Sauvegarde du groupe dans le tableau "raw"
	GIWIK.statusBitsInfo.groups.raw[_params.name] = _params;

	// Si l'objet module X n'est pas encore défini dans le tableau par position
	// if (GIWIK.statusBitsInfo.groups.ordered[_params.module] !== 'object') {GIWIK.statusBitsInfo.groups.ordered[_params.module] = [];}

	// Réinitialisation du tableau ordonné qui va être regénéré
	GIWIK.statusBitsInfo.groups.ordered[_params.module] = [];

	// console.log('group '+_params.name+' added');

	var name, group, _group;

	// Cas d'une position forcée (!== -1)
	for (name in GIWIK.statusBitsInfo.groups.raw)
	{
		_group = GIWIK.statusBitsInfo.groups.raw[name];

		if (_group.module === _params.module && _group.position !== -1)
		{
			// console.log(id,'typeof', typeof GIWIK.statusBitsInfo.groups.ordered[_group.module][_group.position]);
			// Si la position existe déjà dans le tableau ordonné, on la force à -1 pour éviter d'écraser le groupe existant
			if (typeof GIWIK.statusBitsInfo.groups.ordered[_params.module][_group.position] === 'object')
			{
				// console.log('on force la position -1 pour '+name);

				_group.position = -1;
				continue;
			}
			GIWIK.statusBitsInfo.groups.names[_group.name]
			= GIWIK.statusBitsInfo.groups.ordered[_params.module][_group.position]
			= _group;
		}
	}

	// Cas d'une position auto (=== -1 ou undefined|false|null|"")
	for (name in GIWIK.statusBitsInfo.groups.raw)
	{
		_group = array_copy(GIWIK.statusBitsInfo.groups.raw[name]);

		// Affectation d'une position pour la position "auto"
		if (_group.module === _params.module && _group.position === -1)
		{
			// console.log(name+' a la position '+_group.position);

			_group.position = GIWIK.statusBitsInfo.groups.ordered[_params.module].length;

			GIWIK.statusBitsInfo.groups.names[_group.name]
			= GIWIK.statusBitsInfo.groups.ordered[_params.module][_group.position]
			= _group;
		}
	}
};

// Remplit le tableau GIWIK.statusBitsInfo.groups.ordered avec les bits de statuts (pour affichage dans la partie control->detailed status)
GIWIK.statusBitsInfo.fillGroups = function ()
{
	var bit, _bit, _group;

	for (bit in GIWIK._status_bits_info)
	{
		_bit = GIWIK._status_bits_info[bit];

		// COMPATIBILITÉ : Si le paramètre "group" n'est pas défini, on l'ajoute avec le groupe par défaut pour le module -------------------
		if (typeof _bit.group !== 'object')
		{
			// Si le module concerné n'est pas spécifié, on le défini à -1 (-> aucun module)
			if (typeof _bit.module !== 'number')
			{
				_bit.module = -1;
			}

			// Sinon, on affecte automatiquement le bit au groupe par défaut du module concerné
			_bit.group = {name:'__default'+_bit.module+'__', position:-1};

			if (typeof GIWIK.statusBitsInfo.groups.names[_bit.group.name] !== 'object')
			{
				GIWIK.statusBitsInfo.setGroup({name:_bit.group.name, module:_bit.module})
			}
		}
		//-----------------------------------------------------------------------------------------------------------------------------------

		// La propriété "name" du paramètre "group" est obligatoire
		if (typeof _bit.group.name !== 'string')
		{
			console.log('Error: missing "name" property of "group" for bit '+bit+'. (see status.js)');
			continue;
		}

		// Si la position du bit dans le groupe n'est pas définie OU si un autre bit occupe déjà la position définie, on passe la position à -1 (auto)
		if (typeof _bit.group.position !== 'number' || typeof GIWIK.statusBitsInfo.groups.names[_bit.group.name].bits[_bit.group.position] === 'object')
		{
			_bit.group.position = -1;
		}

		// Récupération des infos du groupe de bits
		_group = GIWIK.statusBitsInfo.groups.names[_bit.group.name];

		// Copie de l'ID du module dans le tableau des infos du bit
		_bit.module = _group.module;

		_bit.bit = bit;

		// Cas d'une position forcée
		if (_bit.group.position !== -1)
		{
			// Copie des infos du bit dans l'arborescence (dans le groupe )
			GIWIK.statusBitsInfo.groups.ordered[_group.module][_group.position].bits[_bit.group.position]
			= GIWIK.statusBitsInfo.groups.names[_bit.group.name].bits[_bit.group.position]
			= _bit;
		}
	}

	// Gestion des bits en position "auto" (-1)
	for (bit in GIWIK._status_bits_info)
	{
		_bit = GIWIK._status_bits_info[bit];

		// Cas d'une position auto
		if (_bit.group.position === -1)
		{
			// Définition de la position du bit à la fin des bits déjà déclarés
			_bit.group.position = GIWIK.statusBitsInfo.groups.names[_bit.group.name].bits.length;

			// Récupération des infos du groupe de bits
			_group = GIWIK.statusBitsInfo.groups.names[_bit.group.name];

			// Copie des infos du bit dans l'arborescence (dans le groupe )
			GIWIK.statusBitsInfo.groups.ordered[_group.module][_group.position].bits[_bit.group.position]
			= GIWIK.statusBitsInfo.groups.names[_bit.group.name].bits[_bit.group.position]
			= _bit;
		}
	}
	// console.log(GIWIK.statusBitsInfo.groups);
};

// Action sur les statuts détaillés lors d'un évènement shutdown
GIWIK.setDetailedStatusActivity = function (status)
{
	// Application de la couleur du voyant de chaque module (utilisation de count et pas length pour éviter une erreur en cas de variable undefined)
	for (var i=0; i<count(GIWIK._sensors); i++)
	{
		if (typeof window['Led_Sensor'+i] == 'object')
		{
			if (status === 0)
			{
				window['Led_Sensor'+i].setStatus(0);
			}

			// Les messages de statuts détaillés sont masqués
			$('#sensor'+i+'_infos_ctnr').css('display', ((status === 0) ? 'none' : 'block'));
		}
	}
};

HEADING.readData._plugins.control = function ()
{
	// AFFICHAGE DES MESURES -------------------------------------------------------------------------------------------------------------------------------

	// Gestion du système de coordonnées (avant la suite parce que certaines valeurs sont succeptibles d'être masquées via "false" dans GIWIK._system_data)
	if (!HEADING.init.isdone)
	{
		// Position ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

		// Commes les identifiants suivants peuvent être préfixés ex. : INS_latitude_info, on cherche les id "qui se terminent par"

		// LATITUDE/LONGITUDE + POLAR LATITUDE/LONGITUDE
		$('[id$="latitude_info"], [id$="longitude_info"]').css('display', GIWIK.coordinate_mode === 0/*LatLong*/ ? '' : 'none');
		// UTM
		$('[id$="utm_zone_info"], [id$="utm_north_info"], [id$="utm_east_info"]').css('display', GIWIK.coordinate_mode === 1/*UTM*/ ? '' : 'none');
		// UPS
		$('[id$="ups_zone_info"], [id$="ups_north_info"], [id$="ups_east_info"]').css('display', GIWIK.coordinate_mode === 3/*UPS*/ ? '' : 'none');
		// OSGB
		$('[id$="osgb_zone_info"], [id$="osgb_north_info"], [id$="osgb_east_info"], [id$="osgb_altitude_info"]').css('display', GIWIK.coordinate_mode === 4/*OSGB*/ ? '' : 'none');
		// MGRS
		$('[id$="mgrs_zone_info"], [id$="mgrs_north_info"], [id$="mgrs_east_info"], [id$="mgrs_altitude_info"]').css('display', GIWIK.coordinate_mode === 5/*MGRS*/ ? '' : 'none');
		// GEOREF
		$('[id$="georef_zone_info"], [id$="georef_north_info"], [id$="georef_east_info"], [id$="georef_altitude_info"]').css('display', GIWIK.coordinate_mode === 6/*GEOREF*/ ? '' : 'none');
		// ECEF
		$('[id$="ecef_x_info"], [id$="ecef_y_info"], [id$="ecef_z_info"]').css('display', GIWIK.coordinate_mode === 7/*ECEF*/ ? '' : 'none');
	}

	// Duplication des éventuels écarts types de position (fournis uniquement pour lat/long et polar lat/long) ———————————————
	if (typeof window[system].latitude_stddev !== 'undefined')
	{
		switch (GIWIK.coordinate_mode) 
		{
			case 1 : 
				window[system].utm_north_stddev = window[system].latitude_stddev;
				window[system].utm_east_stddev = window[system].longitude_stddev;
				break;
			// case 2 : 
			// 	window[system].polar_latitude_stddev = window[system].latitude_stddev;
			// 	window[system].polar_longitude_stddev = window[system].longitude_stddev;
			// 	break;
			case 3 : 
				window[system].ups_north_stddev = window[system].latitude_stddev;
				window[system].ups_east_stddev = window[system].longitude_stddev;
				break;
			case 4 : 
				window[system].osgb_north_stddev = window[system].latitude_stddev;
				window[system].osgb_east_stddev = window[system].longitude_stddev;
				window[system].osgb_altitude_stddev = window[system].altitude_stddev;
				break;
			case 5 : 
				window[system].mgrs_north_stddev = window[system].latitude_stddev;
				window[system].mgrs_east_stddev = window[system].longitude_stddev;
				window[system].mgrs_altitude_stddev = window[system].altitude_stddev;
				break;
			case 6 : 
				window[system].georef_north_stddev = window[system].latitude_stddev;
				window[system].georef_east_stddev = window[system].longitude_stddev;
				window[system].georef_altitude_stddev = window[system].altitude_stddev;
				break;
			case 7 : 
				window[system].ecef_y_stddev = window[system].latitude_stddev;
				window[system].ecef_x_stddev = window[system].longitude_stddev;
				window[system].ecef_z_stddev = window[system].altitude_stddev;
				break;
		}
	}
	if (window[system].vehicle_latitude_stddev !== undefined){
		window[system].vehicle_utm_north_stddev = window[system].vehicle_latitude_stddev;
	}
	if (window[system].vehicle_longitude_stddev !== undefined){
		window[system].vehicle_utm_east_stddev = window[system].vehicle_longitude_stddev;
	}	
	
	//————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	var data_name,
		raw_data,
		data_value,
		data_type,
		dom_id,
		_system_data,
		_split,
		s;

	if (in_array(HEADING.name, ['control','control_expertview']))
	{
		_system_data = (HEADING.data_mode === 1) ? GIWIK._system_data.normal : array_merge(GIWIK._system_data.normal,GIWIK._system_data.expert);

		for (data_name in _system_data)
		{
			data_type = (typeof _system_data[data_name] == 'function') ? _system_data[data_name]() : _system_data[data_name];

			// // Si le type de donnée n'est pas défini, on ne traite pas la donnée
			// if (!data_type)
			// {
			// 	continue;
			// }

			dom_id = GIWIK.data.getDomId(data_name);

			// Si la variable existe en mémoire, on stocke sa valeur brute
			try      {raw_data = eval("window[system]."+data_name);} // eval car data_name peut contenir un ou plusieurs "."
			catch(e) {GIWIK.debug("_system_data", data_name, "is missing"); continue;};

			data_value = GIWIK.data.process(data_name, raw_data, data_type);

			// Si l'élément existe dans la page, on écrit sa valeur
			if (document.getElementById(dom_id))
			{
				GIWIK.write(dom_id, data_value);
			}
		}
		// print_r (GIWIK.data.info);
	}

};

// Gestion dynamique de la mise en page au niveau des controles principaux (en fonction de la largeur de la fenetre)
HEADING.display.header.mainControl = function (is_resize)
{
	if (!HEADING.is_external_popup)	// ne concerne pas les popups
	{
		// La taille des elements varie uniquement pour la page de controle
		if (HEADING.name == 'control')
		{
			// Gestion du cas particulier d'un compactmode désactivé alors qu'aucun bouton de controle n'est défini : on repasse en compactmode avec simplement un header en pleine taille
			var css_suffix = (GIWIK.ihm_compactmode === false && typeof GIWIK._maincontrol_buttons == 'undefined') ? 'compact' : GIWIK.css_compactmode;

			// Pour éviter que le chevron ne se balade quelques ms au chargement de la page ///////////
			GIWIK.css.setClass('contenttop', 'contenttop_'+GIWIK.window_size+css_suffix);
			GIWIK.css.setClass('data_ctnr', 'data_ctnr_'+GIWIK.window_size+css_suffix);
			GIWIK.css.setClass('data2_ctnr', 'data2_ctnr_'+GIWIK.window_size+css_suffix);
			GIWIK.css.setClass('data', 'data_'+GIWIK.window_size+css_suffix);
			GIWIK.css.setClass('data2', 'data2_'+GIWIK.window_size+css_suffix);
			GIWIK.css.setClass('status', 'status_'+GIWIK.window_size+css_suffix);
			///////////////////////////////////////////////////////////////////////////////////////////

			$('#maincontrol').css('padding-top',0);
		}
		else
		{
			$('#maincontrol').css('padding-top',8);
		}

		// Redimensionnement du chevron
		window.Statuschevron.resize(GIWIK.maincontrol_size);

		// Gestion de l'affichage des boutons de contrôle (si présents)
		if (typeof GIWIK._maincontrol_buttons == 'object')
		{
			for (var i in GIWIK._maincontrol_buttons)
			{
				window[GIWIK._maincontrol_buttons[i]].resize(GIWIK.maincontrol_size == 'small' ? 'default' : GIWIK.maincontrol_size);
			}

			var button_cssclass = 'button_ctnr_'+GIWIK.maincontrol_size;

			GIWIK.css.setClass('buttonleft_ctnr',  button_cssclass);
			GIWIK.css.setClass('buttonright_ctnr', button_cssclass);
		}
		button_cssclass = null;
	}

	// Logo produit
	GIWIK.css.setClass('productlogo_ctnr', 'productlogo_ctnr_'+GIWIK.maincontrol_size);
};

// Construction de la partie maincontrol (chevron + logo + boutons de contrôle éventuels)
HEADING.construct.header.mainControl = function (param)
{
	// bloc control (chevron+boutons éventuels) + (mesures + statuts sur la page control)
	var maincontrol = '';

	if (HEADING.is_external_popup)
	{
		// Ajout du chevron et du logo produit au contenu de la page
		maincontrol += ''
			+'<div id="external_popup_padding">'
				+'<div id="statuschevron" class="external_popup_chevron"></div>'
				+'<div id="tmpl_productlogo"></div>'
				+'<div id="content" class="displaynone"></div>'
			+'</div>';

		$('body').append(maincontrol);

		// On donne le focus au popup au cas où il serait déjà ouvert (par ex. minimisé dans la barre des tâches)
		window.focus();

		// Pas de boutons de contrôle sur les popups
		HEADING.construct.header.mainControl.buttons = null;
	}
	else
	{
		maincontrol = ''

		+'<div id="contenttop">'

			+'<table><tr>';

			if (HEADING.name == 'control')
			{
				// partie gauche
				maincontrol += ''
				+'<td id="data_ctnr">'
					+'<div id="data"></div>'
				+'</td>';
			}

			// boutons de controle & chevron
			maincontrol += ''
			+((typeof GIWIK._maincontrol_buttons == 'object') ? '<td id="buttonleft_ctnr" class="displaynone"></td>' : '')
			+'<td id="maincontrol"><div id="statuschevron"></div></td>'
			+((typeof GIWIK._maincontrol_buttons == 'object') ? '<td id="buttonright_ctnr" class="displaynone"></td>' : '');

			if (HEADING.name == 'control')
			{
				// partie droite
				maincontrol += ''
				+'<td id="data2_ctnr">'
					+'<div id="data2"></div>'

					+'<div id="status">'
						+'<div id="global_status_line"></div>'
						+'<div id="global_status_title_ctnr"><div id="global_status_title"></div></div>'
						+'<div id="global_status_infos">'
							+'<div id="global_msg"></div>'
							+'<div id="detailed_msg"></div>'
						+'</div>'
					+'</div>'
				+'</td>';
			}

			maincontrol += '</tr></table>'

		+'</div>'

		// logo produit
		+'<div id="tmpl_productlogo"></div>';

		$('body').append(maincontrol);
	}

	// Déclaration du Chevron principal une fois que la partie haute est initialisée
	window.Statuschevron = new Chevron('Statuschevron', false);
	window.Statuschevron.construct('statuschevron');

	// Logo produit
	var productlogo = ''

	+'<div id="productlogo_ctnr" style="display:block;visibility:visible">'
		+'<hr/>'
		+'<span></span>'
	+'</div>';

	$('#tmpl_productlogo').html(productlogo);


	$('#productlogo_ctnr span').html(GIWIK._systems[GIWIK.system_type].logo());

	// Si le logo produit tient sur 2 lignes
	if (GIWIK._systems[GIWIK.system_type].logo_2ndline())
	{
		$('#productlogo_ctnr span').after('<div>'+GIWIK._systems[GIWIK.system_type].logo_2ndline()+'</div>');
	}

	// Pas de liseré pour les popups
	if (HEADING.is_external_popup)
	{
		$('#productlogo_ctnr hr').css('display','none');
	}

	// Appel direct des fonctions d'affichage du header et du main control pour un affichage plus fluide
	HEADING.display.header();
	HEADING.display.header.mainControl();
};


if (HEADING.name == 'control')
{
	HEADING.display._plugins.control = function (is_resize)
	{
		// Par défaut la taille du popup est celle de la fenêtre
		var popupsize = GIWIK.window_size;

		// Si le nombre de modules n'a pas été récupéré
		if (!window.num_ds_sensors)
		{
			window.num_ds_sensors = GIWIK.countDsSensors(GIWIK._ds_sensors);
		}

		// Gestion de l'affichage des modules de statuts détaillés
		if (typeof HEADING.ds_sensor_width == 'undefined')        {HEADING.ds_sensor_width = {small:135, full:145};}
		if (typeof HEADING.ds_sensor_height == 'undefined')       {HEADING.ds_sensor_height = {small:92, full:92};}
		if (typeof HEADING.ds_sensor_firstbox_id == 'undefined')  {HEADING.ds_sensor_firstbox_id = 0;}
		if (typeof HEADING._ds_sensor_displaynone == 'undefined') {HEADING._ds_sensor_displaynone = [];}

		GIWIK.displayControlBoxes(window.num_ds_sensors, HEADING.ds_sensor_width[(GIWIK.window_size == 'medium') ? 'full' : GIWIK.window_size], HEADING.ds_sensor_height[(GIWIK.window_size == 'medium') ? 'full' : GIWIK.window_size], HEADING.ds_sensor_firstbox_id, HEADING._ds_sensor_displaynone);

		switch (GIWIK.window_size)
		{
			//(window.num_ds_sensors-count(HEADING._ds_sensor_displaynone)) permet de ne pas prendre en compte les modules masqués (cas particulier de GRADIOMAGIS/MAGIS)
			case 'small':
				if ((window.num_ds_sensors-count(HEADING._ds_sensor_displaynone)) < 3)       {popupsize = 'mini';}
				break;

			case 'medium':
				if      ((window.num_ds_sensors-count(HEADING._ds_sensor_displaynone)) < 3)  {popupsize = 'mini';}
				else if ((window.num_ds_sensors-count(HEADING._ds_sensor_displaynone)) == 3) {popupsize = 'small';}
				break;

			case 'full':
				if      ((window.num_ds_sensors-count(HEADING._ds_sensor_displaynone)) < 3)  {popupsize = 'mini';}
				else if ((window.num_ds_sensors-count(HEADING._ds_sensor_displaynone)) == 3) {popupsize = 'small';}
				else if ((window.num_ds_sensors-count(HEADING._ds_sensor_displaynone)) == 4) {popupsize = 'medium';}
				break;
		}

		if (document.getElementById('box_detailed_status'))
		{
			GIWIK.css.setClass('box_detailed_status', 'box_detailed_status');
		}

		// Si présence d'une boite "external sensors" (activation à la volée des capteurs externes)
		if (document.getElementById('box_exts'))
		{
			GIWIK.css.setClass('box_exts', 'box_detailed_status');
		}

		var popwidth,
			led_size;

		switch (GIWIK.window_size)
		{
			case 'medium': popwidth = '610px'; led_size = 'full';   break;
			case 'small':  popwidth = '463px'; led_size = 'medium'; break;
			case 'mini':   popwidth = '315px'; led_size = 'mini';   break;
			default:       popwidth = '';      led_size = 'full';
		}

		$('#popup_status').css('width', popwidth);

		// Affichage de la zone des statuts globaux (à la fin du traitement de HEADING.display pour un chargement fluide)
		$('#status').css('visibility','visible');

		if (typeof GIWIK._sensors == 'object')
		{
			// Application de la taille du voyant de chaque module
			for (var i=0; i < GIWIK._sensors.length; i++)
			{
				window['Led_Sensor'+i].resize(led_size);
			}
		}

		if (!HEADING.init.isdone)
		{
			// VS BUG IE au niveau des polices lors d'effets de transparence (ex. Fade() de jQuery) => background à définir de la même couleur que le body
			if (GIWIK._context.ie < 9)
			{
				$('#content_main, #popup_status').css('background-color', GIWIK.css.color_background);
			}
		}
	};

	// Pour exécution à la toute fin (après "display.local")
	HEADING.display.last._plugins.control = function (is_resize)
	{
		if (!HEADING.init.isdone)
		{
			$('#data,#data2,#status').css({
				'height':'auto',
				'visibility':'visible',		// pour annuler la valeur "hidden" de giwik.css
				'display':'none'			// pour autoriser l'effet fadeIn jQuery
			});
			$('#data,#data2,#status').fadeIn();
		}
	};


	HEADING.displayDetailedStatus = function (action)
	{
		if (!HEADING.init.isdone)
		{
			// Ajout de l'action onclick pour l'ouverture des statuts détaillés via la zone des statuts
			GIWIK.setClick('status','HEADING.displayDetailedStatus(\"switch\");');
			$('#status').attr('title', MSG(['chevron','control_mouseover']));
		}

		if (HEADING.detailed_status_is_fading)
		{
			return;
		}

		if (typeof action != 'string')
		{
			action = 'close';
		}

		if (in_array(action, ['open','switch']) && in_array($('#popup_status').css('display'), ['none','']))
		{
			//console.log('OPEN detailed status popup');

			HEADING.detailed_status_is_fading = true;

			// Ecriture dans le cookie pour que le popup se rouvre à la prochaine visite de la page
			STORAGE.setPermanent('popupstatus', 'visible');

			$('#content_main').fadeOut(200, function () {
				$('#popup_status').fadeIn((GIWIK._context.gecko && !HEADING.init.isdone) ? 0/*vs bug freeze gecko 17*/ : 200, function () {
					HEADING.detailed_status_is_fading = false;
				});
			});

		}
		else if (in_array(action, ['close','switch']) && in_array($('#content_main').css('display'), ['none','']))
		{
			//console.log('CLOSE detailed status popup');

			HEADING.detailed_status_is_fading = true;

			// Ecriture dans le cookie pour que le popup ne se rouvre pas à la prochaine visite de la page (sauf alerte au niveau des statuts détaillés)
			STORAGE.setPermanent('popupstatus', 'hidden');

			$('#popup_status').fadeOut(200, function () {
				$('#content_main').fadeIn((GIWIK._context.gecko && !HEADING.init.isdone) ? 0/*vs bug freeze gecko 17*/ : 200, function () {
					HEADING.detailed_status_is_fading = false;
				});
			});
		}
	};

	// Affiche / cache les infos détaillées d'un capteur (uniquement pour SHADOWS)
	HEADING.displayDetailedInfos = function (sensor_name)
	{
		var detailed_infos_element = 'sensor'+sensor_name+'_detailed_infos_ctnr';

		// Visibilite
		if ($('#'+detailed_infos_element).css('display') == 'none')
		{
			eval("HEADING.is_"+sensor_name+"_info_opened = true;");
			$("#"+detailed_infos_element).slideDown(200);
		}
		else
		{
			eval("HEADING.is_"+sensor_name+"_info_opened = false;");
			$("#"+detailed_infos_element).slideUp(200);
		}
	};

	// Méthodes spécifiques aux systèmes embarqués
	if (GIWIK.statusBitsInfo)
	{
		// Construction des infos pour les modules des statuts détaillés de la page control
		HEADING.constructDetailedStatusMsg = function ()
		{
			// Construction des statuts détaillés de chaque module
			var _arbo = [], _module, module,
				_group,	group_position,
				_bit, bit_position,	msg;

			for (module in GIWIK.statusBitsInfo.groups.ordered)
			{
				_module = GIWIK.statusBitsInfo.groups.ordered[module];

				_arbo[module] = '';

				for (group_position in _module)
				{
					_group = _module[group_position];

					// Constructon du titre du groupe
					_arbo[module] += '<div id='+_group.dom_id+' class="ds_group '+(_group.title ? 'with_title' : 'without_title')+'">'
						+'<div class="ds_group_title'+(_group.openable ? ' openable" onclick="$(\'#'+_group.dom_id+' div.ds_group_content\').slideToggle(200)"' : '"')+'>'
							+'<div class="ds_group_led"><div></div></div>'
							+'<div class="ds_group_label">'+_group.title+'</div>'
							+'<div class="ds_group_hr"><hr></div>'
						+'</div>'
						+'<div class="ds_group_content"'+(_group.open === false ? ' style="display:none"' : '')+'>';

					for (bit_position in _group.bits)
					{
						_bit = _group.bits[bit_position];

						if (_bit.module === -1)
						{
							continue;
						}

						msg = undefined;

						switch (typeof _bit.msg)
						{
							case 'number'   : msg = MSG(['detailedstatuscodes',_bit.msg],{disable_undefined_console_msg:true}); break;
							//case 'function' : msg = _bit.msg(); break;	// désactivé pour forcer l'utilisation de fonctions via la table des messages
						}

						if (typeof msg == 'undefined')
						{
							continue;
						}

						if (!_arbo[module])
						{
							_arbo[module] = "";
						}
						_arbo[module] += '<div id="'+GIWIK.statusBitsInfo.msgDomId(_bit.bit)+'" style="display:none">'+msg+'</div>';
					}

					_arbo[module] += '</div>'
					+'</div>';
				}
			}

			for (var i=0; i<GIWIK._sensors.length; i++)
			{
				GIWIK.write('sensor'+i+'_detailed_infos',  _arbo[i], 'append');
				GIWIK.css.setClass('sensor'+i+'_detailed_infos_ctnr', 'displayblock');
			}

			for (var i in GIWIK._sensors)
			{
				$('#sensor'+i+'_infos_ctnr').css('display','block');
			}
		};
	}
}
